// -----------
// DEFAULT MOD

// Rink size globals
float bridge_height = 672;
float rink_width=1150;
float rink_length= 2100;

float arena_width=2200;
float arena_length= 2200;

float arena_height= 500;

statistic @statistic_blocks;
statistic @statistic_saves;
statistic @statistic_shots_against;
statistic @statistic_shots;
statistic @statistic_assists;
statistic @statistic_goals;

team @team_1= _engine.create_team();  
team @team_2= _engine.create_team();  

position @position_c = _engine.create_position();
position @position_lw = _engine.create_position();
position @position_rw = _engine.create_position();
position @position_ld = _engine.create_position();
position @position_rd = _engine.create_position();
position @position_g = _engine.create_position();

// Player Elimination Trigger Callback Function
void test_player_elimination_trigger_callback(player &this_player)
{
  client @this_client = this_player.get_client();
  _engine.server_send_notice(this_client.name + "has touched the elimination trigger\n");
	_engine.server_send_notice("And has to wait until faceoff or new game to rejoin\n");
	this_player.eliminate();
}

 // Initialize is called when the engine is ready
void _initialize()
{
  
	print("[SCRIPT STARTED]\n");
	
	_physics.set_gravity(0,-61,0);
	
	_engine.fullbright_nets=true;
	_engine.fullbright_players=false;
	_engine.shadows_tool=true;
	_engine.textured_active_object_shadows=false;
	
	// MAP
	_engine.set_map_size(1150,2100);

	// STATISTICS

    // Saves
    statistic @statistic_saves = _engine.create_statistic();
    statistic_saves.set_name("Saves");
    statistic_saves.set_abbreviation("SV");
    
    // Shots Against
    statistic @statistic_shots_against = _engine.create_statistic();
    statistic_shots_against.set_name("Shots Against");
    statistic_shots_against.set_abbreviation("SA");
    
    // Blocks
    statistic @statistic_blocks = _engine.create_statistic();
    statistic_blocks.set_name("Blocked Shots");
    statistic_blocks.set_abbreviation("BS");
	
    // Shots
    statistic @statistic_shots = _engine.create_statistic();
    statistic_shots.set_name("Shots");
    statistic_shots.set_abbreviation("S");
	
    // Assists
    statistic @statistic_assists = _engine.create_statistic();
    statistic_assists.set_name("Assists");
    statistic_assists.set_abbreviation("A");
    	
    // Goals
    statistic @statistic_goals = _engine.create_statistic();
    statistic_goals.set_name("Goals");
    statistic_goals.set_abbreviation("G");

	// POSITIONS
	
    // Center
    //position @position_c = _engine.create_position();
    position_c.set_name("Center");
    position_c.set_abbreviation("C");
    position_c.set_spawn(0,0);
	
    // Left Wing
    //position @position_lw = _engine.create_position();
    position_lw.set_name("Left Wing");
    position_lw.set_abbreviation("LW");
    position_lw.set_spawn(135,-1.57);
	
    // Right Wing
    //position @position_rw = _engine.create_position();
    position_rw.set_name("Right Wing");
    position_rw.set_abbreviation("RW");
    position_rw.set_spawn(135,1.57);
	
    // Left Defence
    //position @position_ld = _engine.create_position();
    position_ld.set_name("Left Defence");
    position_ld.set_abbreviation("LD");
    position_ld.set_spawn(105,-2.355);
	
    // Right Defence
    //position @position_rd = _engine.create_position();
    position_rd.set_name("Right Defence");
    position_rd.set_abbreviation("RD");
    position_rd.set_spawn(105,2.355);
	
    // Goaltender
    //position @position_g = _engine.create_position();
    position_g.set_name("Goaltender");
    position_g.set_abbreviation("G");
	  position_g.set_spawn(720,3.14159);
	

	  
	
  // TEAM 1
  //team @team_1 = _engine.create_team();
  team_1.set_name("LA Lakers");
  team_1.set_abbreviation("LAL");
  team_1.set_color_stick (_engine.create_color(94,40,153,255));
  team_1.set_color_shirt (_engine.create_color(242,215,71,255));
  team_1.set_color_pants (_engine.create_color(94,40,153,255));
  team_1.set_color_gloves (_engine.create_color(94,40,153,255));
  team_1.set_color_hat (_engine.create_color(94,40,153,255));
  team_1.set_color_net (_engine.create_color(94,40,153,255));
  team_1.set_spawn (0,bridge_height+20,95,3.14159);
  

	// Team 2  
	//team @team_2 = _engine.create_team();  
  team_2.set_name("TempleOS");
  team_2.set_abbreviation("TOS");
  team_2.set_color_stick (_engine.create_color(17,238,227,255));
  team_2.set_color_shirt (_engine.create_color(17,238,227,255));
  team_2.set_color_pants (_engine.create_color(248,218,7,255));
  team_2.set_color_gloves (_engine.create_color(17,238,227,255));
  team_2.set_color_hat (_engine.create_color(17,238,227,255));
  team_2.set_color_net (_engine.create_color(17,238,227,255));
  team_2.set_spawn (0,bridge_height+20,-95,0);
 
  create_play_area();


  // TEAM 2
  net @net_1 = _engine.create_net_square(0,672,(rink_length/2)*.8668,88,38,25,3,3.14159);
	net_1.set_team(team_1);

  net @net_2 = _engine.create_net_square(0,672,-(rink_length/2)*.8668,88,38,25,3,0);
  net_2.set_team(team_2);

	

	
	
	
	
	
	
	

  
  

	// PUCK MATERIAL
	physics_material @puck_material = _physics.create_material();
	puck_material.mode = dContactBounce | dContactSoftCFM | dContactSoftERP  ;
  puck_material.mu = 10.99;
  puck_material.bounce = .90;
  puck_material.bounce_vel = .90;
  puck_material.soft_cfm = .8003;
  puck_material.soft_erp = .39;
	
	

  

	
	
	// Example Net

	return;
}

// Deinitialize is called just prior to deinitializing the game engine or before switching mods
void _deinitialize()
{
	print("[SCRIPT ENDED]\n");
}

void create_play_area(){

  // LIGHTS
  game_object @shadow_light = _engine.create_game_light(0,50000);
  shadow_light.set_position(0,10000,0);
  shadow_light.set_rotation(90,0,0);
  shadow_light.set_color(1,1,1,1);
  shadow_light.light_cast_shadows(true);

    game_object @arena_light_1 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_1.light_set_type(0);
    arena_light_1.light_cast_shadows(false);
    arena_light_1.set_position((rink_width)*-2.55,600,(rink_length)*-1.25);
    arena_light_1.set_color(1,1,1,0);
    
    game_object @arena_light_2 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_2.light_set_type(0);
    arena_light_2.light_cast_shadows(false);
    arena_light_2.set_position((rink_width)*-2.55,600,(rink_length)*1.25);
    arena_light_2.set_color(1,1,1,0);
    
    game_object @arena_light_3 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_3.light_set_type(0);
    arena_light_3.light_cast_shadows(false);
    arena_light_3.set_position((rink_width)*2.55,600,(rink_length)*-1.25);
    arena_light_3.set_color(1,1,1,0);
    
    game_object @arena_light_4 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_4.light_set_type(0);
    arena_light_4.light_cast_shadows(false);
    arena_light_4.set_position((rink_width)*2.55,600,(rink_length)*1.25);
    arena_light_4.set_color(1,1,1,0);
    


 
  
  // ICE MATERIAL
	physics_material @ice_material = _physics.create_material();
	ice_material.mode =  dContactSoftCFM | dContactApprox0;
  ice_material.mu = .4;
  ice_material.bounce = .0;
  ice_material.soft_cfm = .0001;
  ice_material.soft_erp = .89;
  
  // TOOL ICE MATERIAL
	physics_material @tool_ice_material = _physics.create_material();
	tool_ice_material.mode =  dContactSoftCFM | dContactApprox0;
  tool_ice_material.mu = .4;
  tool_ice_material.bounce = .0;
  tool_ice_material.soft_cfm = .3;
  tool_ice_material.soft_erp = .49;
  
  // ENVIRONMENT MATERIAL
	physics_material @environment_material = _physics.create_material();
	environment_material.mode = dContactBounce | dContactSoftCFM ;
  environment_material.mu = .99;
  environment_material.bounce = .74;
  environment_material.soft_cfm = .01;
  environment_material.soft_erp = .85;

  // GROUND
	physics_object @ground = _physics.create_plane(0,1,0,-700);
  ground.set_material(ice_material);
  ground.collision_group = COLLISION_GROUP_GROUND;
  ground.set_space(_physics.space_ground);

  // GROUND STICK COLLIDER
  //physics_object @ground_stick = _physics.create_plane(0,bridge_height,0,0);
  //ground_stick.set_material(tool_ice_material);
  //ground_stick.set_space(_physics.space_ground_stick);

  game_object @bridge_collider=_engine.create_game_cube( 440,8,4000, 0);
  bridge_collider.set_position(0,bridge_height-4,0);
  bridge_collider.set_color(255,0,0,0);
  bridge_collider._physics_object.set_material(ice_material);
  bridge_collider._physics_object.set_space(_physics.space_ground);
  bridge_collider._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @curbL_collider=_engine.create_game_cube( 50,8,4000, 0);
  curbL_collider.set_position(250,bridge_height,0);
  curbL_collider.set_color(0,255,0,0);
  curbL_collider._physics_object.set_material(ice_material);
  curbL_collider._physics_object.set_space(_physics.space_ground);
  curbL_collider._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @curbR_collider=_engine.create_game_cube( 50,8,4000, 0);
  curbR_collider.set_position(-250,bridge_height,0);
  curbR_collider.set_color(255,0,0,0);
  curbR_collider._physics_object.set_material(ice_material);
  curbR_collider._physics_object.set_space(_physics.space_ground);
  curbR_collider._physics_object.collision_group = COLLISION_GROUP_GROUND;
 
  
  game_object @this_player_elimination_trigger = _engine.create_game_cube_trigger( 0,-400,0,3000,600,3000);
  this_player_elimination_trigger.set_player_trigger_callback('test_player_elimination_trigger_callback');
  this_player_elimination_trigger.set_color(0,255,0,0);
	

  
  
  
  
  //game_object @ramp=_engine.create_game_cube( 120, 12,270, 0);
	//ramp.set_position(-320., 20, 0);
	//ramp.set_rotation(.2,0,0);
  //ramp._physics_object.set_material(environment_material);
  //ramp._physics_object.set_space(_physics.space_environment);
  //ramp._physics_object.collision_group = COLLISION_GROUP_CUSTOM_GROUND;
  
 
	

	
	
	
	game_object @canyon=_engine.create_game_mesh("canyon.obj", 1,1,1, -1);
	canyon.set_position(0,0,0);
	canyon.set_rotation(270,90,0);
	canyon.load_texture("canyon.png");
	
	game_object @bridge=_engine.create_game_mesh("bridge.obj", 1,1,1, -1);
	bridge.set_rotation(270,90,0);
	bridge.set_position(0,0,0);
	bridge.load_texture("bridge.png");


	environment_object @boards_invisible = _engine.create_rounded_container(0,0 ,0,rink_width*.99,1956,rink_length*.99,22,rink_width/3,25,1,false,true);

	//boards_invisible.set_color(250,250,250,10);
	
	environment_object @boards = _engine.create_rounded_container(0,0 ,0,rink_width*.99,56,rink_length*.99,22,rink_width/3,25,1,true,false);
	environment_object @glass =  _engine.create_rounded_container(0,29+500,0,rink_width*.99,1000,rink_length*.99,22,rink_width/3,25,2,true,false);
	 
	boards.set_color(250,250,250,0);
	glass.set_color(220,220,240,0);
  glass.set_material_flag(EMF_LIGHTING, false);

}

void _start_game(){
  print("[_start_game]\n");
  
  _engine.game_round_time = 5 * 60;
  

  
}

void _end_game(){
  print("[_end_game]\n");
}

void _start_round(){
  print("[_start_period]\n");
  
  

}

void _end_round(){  
  print("[_end_round]\n");
  
}

void _start_play(){
  print("[_start_play]\n");
  
  
  
  if(_engine.game_round > 0){
    active_object @new_puck = _engine.create_active_puck(0,bridge_height+30,0,3.2,2.55,0.02);
  }else{
 
      for(int z = 0; z < 8; z++){
        //print("Adding Puck\n");
        //active_object @new_puck = _engine.create_active_puck(sin(i*5),35+(i*5),cos(i*5),3.2,2.35,0.02);
        active_object @new_puck2 = _engine.create_active_puck(100*sin(z*45),bridge_height+35,100*cos(z*45),3.2,2.55,0.03);
        //active_object @new_puck = _engine.create_active_puck(0 * sin(i*2),90 + (i*3),0 * cos(i*5),3.2,2.35,0.02);
        //active_object @new_puck = _engine.create_active_puck(100 * sin(i*.15),90 + (i*3),100 * cos(i*.15),3.2,2.35,0.02);
      }
  }
      
}