// Rink size globals
float rink_width=1050;
float rink_length= 2444;

float mapAlpha = 0; //toggle collision mesh visibility.

float mapscale= 50;

float arena_width=2444;
float arena_length= 2444;

float arena_height= 500;

statistic @statistic_blocks;
statistic @statistic_saves;
statistic @statistic_shots_against;
statistic @statistic_shots;
statistic @statistic_assists;
statistic @statistic_goals;

 // Initialize is called when the engine is ready
void _initialize()
{
	print("[SCRIPT STARTED]\n");
	
	_physics.set_gravity(0,-61,0);
	
	_engine.fullbright_nets=true;
	_engine.fullbright_players=false;
	_engine.shadows_tool=true;
	_engine.textured_active_object_shadows=false;
	
	// MAP
	_engine.set_map_size(1150,2100);

	// STATISTICS

    // Saves
    statistic @statistic_saves = _engine.create_statistic();
    statistic_saves.set_name("Saves");
    statistic_saves.set_abbreviation("SV");
    
    // Shots Against
    statistic @statistic_shots_against = _engine.create_statistic();
    statistic_shots_against.set_name("Shots Against");
    statistic_shots_against.set_abbreviation("SA");
    
    // Blocks
    statistic @statistic_blocks = _engine.create_statistic();
    statistic_blocks.set_name("Blocked Shots");
    statistic_blocks.set_abbreviation("BS");
	
    // Shots
    statistic @statistic_shots = _engine.create_statistic();
    statistic_shots.set_name("Shots");
    statistic_shots.set_abbreviation("S");
	
    // Assists
    statistic @statistic_assists = _engine.create_statistic();
    statistic_assists.set_name("Assists");
    statistic_assists.set_abbreviation("A");
    	
    // Goals
    statistic @statistic_goals = _engine.create_statistic();
    statistic_goals.set_name("Goals");
    statistic_goals.set_abbreviation("G");

	// POSITIONS
	
    // Center
    position @position_c = _engine.create_position();
    position_c.set_name("Center");
    position_c.set_abbreviation("C");
    position_c.set_spawn(0,0);
	
    // Left Wing
    position @position_lw = _engine.create_position();
    position_lw.set_name("Left Wing");
    position_lw.set_abbreviation("LW");
    position_lw.set_spawn(135,-1.57);
	
    // Right Wing
    position @position_rw = _engine.create_position();
    position_rw.set_name("Right Wing");
    position_rw.set_abbreviation("RW");
    position_rw.set_spawn(135,1.57);
	
    // Left Defence
    position @position_ld = _engine.create_position();
    position_ld.set_name("Left Defence");
    position_ld.set_abbreviation("LD");
    position_ld.set_spawn(125,-2.355);
	
    // Right Defence
    position @position_rd = _engine.create_position();
    position_rd.set_name("Right Defence");
    position_rd.set_abbreviation("RD");
    position_rd.set_spawn(125,2.355);
	
    // Goaltender
    position @position_g = _engine.create_position();
    position_g.set_name("Goaltender");
    position_g.set_abbreviation("G");
	  position_g.set_spawn(720,3.14159);
	

	  
	
  // TEAM 1
  team @team_1 = _engine.create_team();
  team_1.set_name("Insurrectionists");
  team_1.set_abbreviation("RED");
  team_1.set_color_stick (_engine.create_color(200,50,50,0));
  team_1.set_color_shirt (_engine.create_color(200,50,50,0));
  team_1.set_color_pants (_engine.create_color(200,50,50,0));
  team_1.set_color_gloves (_engine.create_color(200,50,50,0));
  team_1.set_color_hat (_engine.create_color(200,50,50,0));
  team_1.set_color_net (_engine.create_color(200,50,50,0));
  team_1.set_spawn (95,200,0,3.14159);
  

	// Team 2  
	team @team_2 = _engine.create_team();  
  team_2.set_name("3I Station Security");
  team_2.set_abbreviation("BLU");
  team_2.set_color_stick (_engine.create_color(50,50,200,0));
  team_2.set_color_shirt (_engine.create_color(50,50,200,0));
  team_2.set_color_pants (_engine.create_color(50,50,200,0));
  team_2.set_color_gloves (_engine.create_color(50,50,200,0));
  team_2.set_color_hat (_engine.create_color(50,50,200,0));
  team_2.set_color_net (_engine.create_color(50,50,200,0));
  team_2.set_spawn (-95,200,0,0);
 
  bot @bot1 = _engine.create_bot("Jim",team_2,position_c);
  bot @bot2 =_engine.create_bot("Bim",team_2,position_lw);
 
  create_play_area();


  // TEAM 2
  net @net_1 = _engine.create_net_square(-100,100,-600,100,40,25,1,-1.5708);
	net_1.set_team(team_1);

  net @net_2 = _engine.create_net_square(100,100,600,100,40,25,1,1.5708);
  net_2.set_team(team_2);


	  
	
	
	

  
  

	// PUCK MATERIAL
	physics_material @puck_material = _physics.create_material();
	puck_material.mode = dContactBounce | dContactSoftCFM | dContactSoftERP  ;
  puck_material.mu = 10.99;
  puck_material.bounce = .90;
  puck_material.bounce_vel = .90;
  puck_material.soft_cfm = .8003;
  puck_material.soft_erp = .39;
	
	

	
	
	// Example Net

	return;
}

void test_int(int output)
{
	print( "numeric argument: " + formatInt(output) + "\n" );
}


void test_string(string output)
{
	print("string argument: " + output + "\n" );
}

void test_player(player &this_player)
{
	print("Player function started\n" );
	print("Passed Player ID: " + this_player.id + "\n");
	//print("Passed Player Name: " + this_player.name + "\n");
}

// Deinitialize is called just prior to deinitializing the game engine or before switching mods
void _deinitialize()
{
	print("[SCRIPT ENDED]\n");
}

void create_play_area(){

  // LIGHTS

   

 
  
    game_object @arena_light_1 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_1.light_set_type(0);
    arena_light_1.light_cast_shadows(false);
    arena_light_1.set_position(0,0,0);
    arena_light_1.set_color(1,1,1,1);
    
    game_object @arena_light_2 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_2.light_set_type(0);
    arena_light_2.light_cast_shadows(false);
    arena_light_2.set_position((rink_width)*-2.55,900,(rink_length)*1.25);
    arena_light_2.set_color(1,1,1,0);
    
    game_object @arena_light_3 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_3.light_set_type(0);
    arena_light_3.light_cast_shadows(false);
    arena_light_3.set_position((rink_width)*2.55,900,(rink_length)*-1.25);
    arena_light_3.set_color(1,1,1,0);
    
    game_object @arena_light_4 = _engine.create_game_light(0,rink_length*1.75);
    arena_light_4.light_set_type(0);
    arena_light_4.light_cast_shadows(false);
    arena_light_4.set_position((rink_width)*2.55,900,(rink_length)*1.25);
    arena_light_4.set_color(1,1,1,0);
    


 
  
  // ICE MATERIAL
	physics_material @ice_material = _physics.create_material();
	ice_material.mode =  dContactSoftCFM | dContactApprox0;
  ice_material.mu = .4;
  ice_material.bounce = .0;
  ice_material.soft_cfm = .0001;
  ice_material.soft_erp = .89;
  
  // TOOL ICE MATERIAL
	physics_material @tool_ice_material = _physics.create_material();
	tool_ice_material.mode =  dContactSoftCFM | dContactApprox0;
  tool_ice_material.mu = .4;
  tool_ice_material.bounce = .0;
  tool_ice_material.soft_cfm = .3;
  tool_ice_material.soft_erp = .49;
  
  // ENVIRONMENT MATERIAL
	physics_material @environment_material = _physics.create_material();
	environment_material.mode = dContactBounce | dContactSoftCFM ;
  environment_material.mu = .99;
  environment_material.bounce = .74;
  environment_material.soft_cfm = .01;
  environment_material.soft_erp = .35;

  // GROUND
	physics_object @ground = _physics.create_plane(0,1,0,0);
  ground.set_material(ice_material);
  ground.collision_group = COLLISION_GROUP_GROUND;
  ground.set_space(_physics.space_ground);

  // GROUND STICK COLLIDER
  physics_object @ground_stick = _physics.create_plane(0,1,0,-2.75);
  ground_stick.set_material(tool_ice_material);
  ground_stick.set_space(_physics.space_ground_stick);

	
	// CEILING
	game_object @ceiling=_engine.create_game_cube((arena_width), 1 ,(arena_length), 0);
	ceiling.set_position(0,350, 0);
	ceiling.set_color(112,112,112,255);
	ceiling.set_fullbright();
    ceiling._physics_object.set_material(environment_material);
    ceiling._physics_object.set_space(_physics.space_environment);
    ceiling._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	
	// WALLS
	
	game_object @box_red_goalroom=_engine.create_game_cube(50,50,50,0);
	box_red_goalroom.set_position (-125,125,575);
	box_red_goalroom.set_color(255,0,0,mapAlpha);
	box_red_goalroom._physics_object.set_material(environment_material);
	box_red_goalroom._physics_object.set_space(_physics.space_environment);
	box_red_goalroom._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @box_blue_goalroom=_engine.create_game_cube(50,50,50,0);
	box_blue_goalroom.set_position (125,125,-575);
	box_blue_goalroom.set_color(0,0,255,mapAlpha);
	box_blue_goalroom._physics_object.set_material(environment_material);
	box_blue_goalroom._physics_object.set_space(_physics.space_environment);
	box_blue_goalroom._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	
	game_object @wall_red_central=_engine.create_game_cube(400,250,50,0);
	wall_red_central.set_position (0,125,225);
	wall_red_central.set_color(255,0,0,mapAlpha);
	wall_red_central._physics_object.set_material(environment_material);
	wall_red_central._physics_object.set_space(_physics.space_environment);
	wall_red_central._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_central=_engine.create_game_cube(400,250,50,0);
	wall_blue_central.set_position (0,125,-225);
	wall_blue_central.set_color(0,0,255,mapAlpha);
	wall_blue_central._physics_object.set_material(environment_material);
	wall_blue_central._physics_object.set_space(_physics.space_environment);
	wall_blue_central._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_big=_engine.create_game_cube(200,250,400,0);
	wall_red_big.set_position (-400,125,250);
	wall_red_big.set_color(255,0,0,mapAlpha);
	wall_red_big._physics_object.set_material(environment_material);
	wall_red_big._physics_object.set_space(_physics.space_environment);
	wall_red_big._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_big2=_engine.create_game_cube(300,250,250,0);
	wall_red_big2.set_position (-450,125,-175);
	wall_red_big2.set_color(255,0,0,mapAlpha);
	wall_red_big2._physics_object.set_material(environment_material);
	wall_red_big2._physics_object.set_space(_physics.space_environment);
	wall_red_big2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_big3=_engine.create_game_cube(50,200,500,0);
	wall_red_big3.set_position (-625,100,200);
	wall_red_big3.set_color(255,0,0,mapAlpha);
	wall_red_big3._physics_object.set_material(environment_material);
	wall_red_big3._physics_object.set_space(_physics.space_environment);
	wall_red_big3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_mez1=_engine.create_game_cube(50,150,200,0);
	wall_red_mez1.set_position (-725,125,600);
	wall_red_mez1.set_color(255,0,0,mapAlpha);
	wall_red_mez1._physics_object.set_material(environment_material);
	wall_red_mez1._physics_object.set_space(_physics.space_environment);
	wall_red_mez1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_mez2=_engine.create_game_cube(750,200,50,0);
	wall_red_mez2.set_position (-275,150,775);
	wall_red_mez2.set_color(255,0,0,mapAlpha);
	wall_red_mez2._physics_object.set_material(environment_material);
	wall_red_mez2._physics_object.set_space(_physics.space_environment);
	wall_red_mez2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @ceil_red_low=_engine.create_game_cube(300,150,100,0);
	ceil_red_low.set_position (-450,175,0);
	ceil_red_low.set_color(255,0,0,mapAlpha);
	ceil_red_low._physics_object.set_material(environment_material);
	ceil_red_low._physics_object.set_space(_physics.space_environment);
	ceil_red_low._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_big=_engine.create_game_cube(200,250,400,0);
	wall_blue_big.set_position (400,125,-250);
	wall_blue_big.set_color(0,0,255,mapAlpha);
	wall_blue_big._physics_object.set_material(environment_material);
	wall_blue_big._physics_object.set_space(_physics.space_environment);
	wall_blue_big._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_big2=_engine.create_game_cube(300,250,250,0);
	wall_blue_big2.set_position (450,125,175);
	wall_blue_big2.set_color(0,0,255,mapAlpha);
	wall_blue_big2._physics_object.set_material(environment_material);
	wall_blue_big2._physics_object.set_space(_physics.space_environment);
	wall_blue_big2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_big3=_engine.create_game_cube(50,200,500,0);
	wall_blue_big3.set_position (625,100,-200);
	wall_blue_big3.set_color(0,0,255,mapAlpha);
	wall_blue_big3._physics_object.set_material(environment_material);
	wall_blue_big3._physics_object.set_space(_physics.space_environment);
	wall_blue_big3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_mez1=_engine.create_game_cube(50,150,200,0);
	wall_blue_mez1.set_position (725,125,-600);
	wall_blue_mez1.set_color(0,0,255,mapAlpha);
	wall_blue_mez1._physics_object.set_material(environment_material);
	wall_blue_mez1._physics_object.set_space(_physics.space_environment);
	wall_blue_mez1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_mez2=_engine.create_game_cube(750,200,50,0);
	wall_blue_mez2.set_position (275,150,-775);
	wall_blue_mez2.set_color(0,0,255,mapAlpha);
	wall_blue_mez2._physics_object.set_material(environment_material);
	wall_blue_mez2._physics_object.set_space(_physics.space_environment);
	wall_blue_mez2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_corner1=_engine.create_game_cube(71,100,71,0);
	wall_blue_lower_corner1.set_position (50,50,150);
	wall_blue_lower_corner1.set_rotation (0,0.785398,0);
	wall_blue_lower_corner1.set_color(0,0,255,mapAlpha);
	wall_blue_lower_corner1._physics_object.set_material(environment_material);
	wall_blue_lower_corner1._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_corner1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_corner2=_engine.create_game_cube(71,100,71,0);
	wall_blue_lower_corner2.set_position (150,50,150);
	wall_blue_lower_corner2.set_rotation (0,0.785398,0);
	wall_blue_lower_corner2.set_color(0,0,255,mapAlpha);
	wall_blue_lower_corner2._physics_object.set_material(environment_material);
	wall_blue_lower_corner2._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_corner2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_corner3=_engine.create_game_cube(100,100,100,0);
	wall_blue_lower_corner3.set_position (100,50,150);
	wall_blue_lower_corner3.set_color(0,0,255,mapAlpha);
	wall_blue_lower_corner3._physics_object.set_material(environment_material);
	wall_blue_lower_corner3._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_corner3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_corner4=_engine.create_game_cube(50,100,50,0);
	wall_blue_lower_corner4.set_position (175,50,175);
	wall_blue_lower_corner4.set_color(0,0,255,mapAlpha);
	wall_blue_lower_corner4._physics_object.set_material(environment_material);
	wall_blue_lower_corner4._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_corner4._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower=_engine.create_game_cube(200,100,100,0);
	wall_red_lower.set_position (-100,50,200);
	wall_red_lower.set_color(255,0,0,mapAlpha);
	wall_red_lower._physics_object.set_material(environment_material);
	wall_red_lower._physics_object.set_space(_physics.space_environment);
	wall_red_lower._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower=_engine.create_game_cube(200,100,100,0);
	wall_blue_lower.set_position (100,50,-200);
	wall_blue_lower.set_color(0,0,255,mapAlpha);
	wall_blue_lower._physics_object.set_material(environment_material);
	wall_blue_lower._physics_object.set_space(_physics.space_environment);
	wall_blue_lower._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	
	game_object @wall_blue_mez_corner1=_engine.create_game_cube(71,150,71,0);
	wall_blue_mez_corner1.set_position (700,125,-450);
	wall_blue_mez_corner1.set_rotation (0,0.785398,0);
	wall_blue_mez_corner1.set_color(0,0,255,mapAlpha);
	wall_blue_mez_corner1._physics_object.set_material(environment_material);
	wall_blue_mez_corner1._physics_object.set_space(_physics.space_environment);
	wall_blue_mez_corner1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
		
	game_object @wall_blue_mez_corner2=_engine.create_game_cube(71,150,71,0);
	wall_blue_mez_corner2.set_position (700,125,-750);
	wall_blue_mez_corner2.set_rotation (0,0.785398,0);
	wall_blue_mez_corner2.set_color(0,0,255,mapAlpha);
	wall_blue_mez_corner2._physics_object.set_material(environment_material);
	wall_blue_mez_corner2._physics_object.set_space(_physics.space_environment);
	wall_blue_mez_corner2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_mez_corner3=_engine.create_game_cube(71,150,71,0);
	wall_blue_mez_corner3.set_position (400,125,-750);
	wall_blue_mez_corner3.set_rotation (0,0.785398,0);
	wall_blue_mez_corner3.set_color(0,0,255,mapAlpha);
	wall_blue_mez_corner3._physics_object.set_material(environment_material);
	wall_blue_mez_corner3._physics_object.set_space(_physics.space_environment);
	wall_blue_mez_corner3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_mez_corner4=_engine.create_game_cube(71,150,71,0);
	wall_blue_mez_corner4.set_position (400,125,-450);
	wall_blue_mez_corner4.set_rotation (0,0.785398,0);
	wall_blue_mez_corner4.set_color(0,0,255,mapAlpha);
	wall_blue_mez_corner4._physics_object.set_material(environment_material);
	wall_blue_mez_corner4._physics_object.set_space(_physics.space_environment);
	wall_blue_mez_corner4._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

	game_object @wall_red_lower_corner1=_engine.create_game_cube(71,100,71,0);
	wall_red_lower_corner1.set_position (-50,50,-150);
	wall_red_lower_corner1.set_rotation (0,0.785398,0);
	wall_red_lower_corner1.set_color(255,0,0,mapAlpha);
	wall_red_lower_corner1._physics_object.set_material(environment_material);
	wall_red_lower_corner1._physics_object.set_space(_physics.space_environment);
	wall_red_lower_corner1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_corner2=_engine.create_game_cube(71,100,71,0);
	wall_red_lower_corner2.set_position (-150,50,-150);
	wall_red_lower_corner2.set_rotation (0,0.785398,0);
	wall_red_lower_corner2.set_color(255,0,0,mapAlpha);
	wall_red_lower_corner2._physics_object.set_material(environment_material);
	wall_red_lower_corner2._physics_object.set_space(_physics.space_environment);
	wall_red_lower_corner2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_corner3=_engine.create_game_cube(100,100,100,0);
	wall_red_lower_corner3.set_position (-100,50,-150);
	wall_red_lower_corner3.set_color(255,0,0,mapAlpha);
	wall_red_lower_corner3._physics_object.set_material(environment_material);
	wall_red_lower_corner3._physics_object.set_space(_physics.space_environment);
	wall_red_lower_corner3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_corner4=_engine.create_game_cube(50,100,50,0);
	wall_red_lower_corner4.set_position (-175,50,-175);
	wall_red_lower_corner4.set_color(255,0,0,mapAlpha);
	wall_red_lower_corner4._physics_object.set_material(environment_material);
	wall_red_lower_corner4._physics_object.set_space(_physics.space_environment);
	wall_red_lower_corner4._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_curve1=_engine.create_game_cube(54,100,54,0);
	wall_red_lower_curve1.set_position (-319.25,50,83);
	wall_red_lower_curve1.set_rotation (0,1.309,0);
	wall_red_lower_curve1.set_color(255,0,0,mapAlpha);
	wall_red_lower_curve1._physics_object.set_material(environment_material);
	wall_red_lower_curve1._physics_object.set_space(_physics.space_environment);
	wall_red_lower_curve1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_curve2=_engine.create_game_cube(54,100,54,0);
	wall_red_lower_curve2.set_position (-288,50,137);
	wall_red_lower_curve2.set_rotation (0,0.785398,0);
	wall_red_lower_curve2.set_color(255,0,0,mapAlpha);
	wall_red_lower_curve2._physics_object.set_material(environment_material);
	wall_red_lower_curve2._physics_object.set_space(_physics.space_environment);
	wall_red_lower_curve2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_lower_curve3=_engine.create_game_cube(54,100,54,0);
	wall_red_lower_curve3.set_position (-233,50,169.25);
	wall_red_lower_curve3.set_rotation (0,0.261799,0);
	wall_red_lower_curve3.set_color(255,0,0,mapAlpha);
	wall_red_lower_curve3._physics_object.set_material(environment_material);
	wall_red_lower_curve3._physics_object.set_space(_physics.space_environment);
	wall_red_lower_curve3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_mez_corner1=_engine.create_game_cube(71,150,71,0);
	wall_red_mez_corner1.set_position (-700,125,450);
	wall_red_mez_corner1.set_rotation (0,0.785398,0);
	wall_red_mez_corner1.set_color(255,0,0,mapAlpha);
	wall_red_mez_corner1._physics_object.set_material(environment_material);
	wall_red_mez_corner1._physics_object.set_space(_physics.space_environment);
	wall_red_mez_corner1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
		
	game_object @wall_red_mez_corner2=_engine.create_game_cube(71,150,71,0);
	wall_red_mez_corner2.set_position (-700,125,750);
	wall_red_mez_corner2.set_rotation (0,0.785398,0);
	wall_red_mez_corner2.set_color(255,0,0,mapAlpha);
	wall_red_mez_corner2._physics_object.set_material(environment_material);
	wall_red_mez_corner2._physics_object.set_space(_physics.space_environment);
	wall_red_mez_corner2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_mez_corner3=_engine.create_game_cube(71,150,71,0);
	wall_red_mez_corner3.set_position (-400,125,750);
	wall_red_mez_corner3.set_rotation (0,0.785398,0);
	wall_red_mez_corner3.set_color(255,0,0,mapAlpha);
	wall_red_mez_corner3._physics_object.set_material(environment_material);
	wall_red_mez_corner3._physics_object.set_space(_physics.space_environment);
	wall_red_mez_corner3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_red_mez_corner4=_engine.create_game_cube(71,150,71,0);
	wall_red_mez_corner4.set_position (-400,125,450);
	wall_red_mez_corner4.set_rotation (0,0.785398,0);
	wall_red_mez_corner4.set_color(255,0,0,mapAlpha);
	wall_red_mez_corner4._physics_object.set_material(environment_material);
	wall_red_mez_corner4._physics_object.set_space(_physics.space_environment);
	wall_red_mez_corner4._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_curve1=_engine.create_game_cube(54,100,54,0);
	wall_blue_lower_curve1.set_position (319.25,50,-83);
	wall_blue_lower_curve1.set_rotation (0,1.309,0);
	wall_blue_lower_curve1.set_color(0,0,255,mapAlpha);
	wall_blue_lower_curve1._physics_object.set_material(environment_material);
	wall_blue_lower_curve1._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_curve1._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_curve2=_engine.create_game_cube(54,100,54,0);
	wall_blue_lower_curve2.set_position (288,50,-137);
	wall_blue_lower_curve2.set_rotation (0,0.785398,0);
	wall_blue_lower_curve2.set_color(0,0,255,mapAlpha);
	wall_blue_lower_curve2._physics_object.set_material(environment_material);
	wall_blue_lower_curve2._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_curve2._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @wall_blue_lower_curve3=_engine.create_game_cube(54,100,54,0);
	wall_blue_lower_curve3.set_position (233,50,-169.25);
	wall_blue_lower_curve3.set_rotation (0,0.261799,0);
	wall_blue_lower_curve3.set_color(0,0,255,mapAlpha);
	wall_blue_lower_curve3._physics_object.set_material(environment_material);
	wall_blue_lower_curve3._physics_object.set_space(_physics.space_environment);
	wall_blue_lower_curve3._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

	game_object @ceil_blue_low=_engine.create_game_cube(300,150,100,0);
	ceil_blue_low.set_position (450,175,0);
	ceil_blue_low.set_color(0,0,255,mapAlpha);
	ceil_blue_low._physics_object.set_material(environment_material);
	ceil_blue_low._physics_object.set_space(_physics.space_environment);
	ceil_blue_low._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	// PILLARS/ROUNDED CORNERS
	game_object @pillar_red_central=_engine.create_game_cylinder(25,250,0);
	pillar_red_central.set_position (-200,125,25);
	pillar_red_central.set_rotation (1.5708,0,0);
	pillar_red_central.set_color(255,0,0,mapAlpha);
	pillar_red_central._physics_object.set_material(environment_material);
	pillar_red_central._physics_object.set_space(_physics.space_environment);
	pillar_red_central._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @pillar_red_side=_engine.create_game_cylinder(25,100,0);
	pillar_red_side.set_position (-200,200,225);
	pillar_red_side.set_rotation (1.5708,0,0);
	pillar_red_side.set_color(255,0,0,mapAlpha);
	pillar_red_side._physics_object.set_material(environment_material);
	pillar_red_side._physics_object.set_space(_physics.space_environment);
	pillar_red_side._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	
	
	game_object @pillar_blue_central=_engine.create_game_cylinder(25,250,0);
	pillar_blue_central.set_position (200,125,-25);
	pillar_blue_central.set_rotation (1.5708,0,0);
	pillar_blue_central.set_color(0,0,255,mapAlpha);
	pillar_blue_central._physics_object.set_material(environment_material);
	pillar_blue_central._physics_object.set_space(_physics.space_environment);
	pillar_blue_central._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;
	
	game_object @pillar_blue_side=_engine.create_game_cylinder(25,100,0);
	pillar_blue_side.set_position (200,200,-225);
	pillar_blue_side.set_rotation (1.5708,0,0);
	pillar_blue_side.set_color(0,0,255,mapAlpha);
	pillar_blue_side._physics_object.set_material(environment_material);
	pillar_blue_side._physics_object.set_space(_physics.space_environment);
	pillar_blue_side._physics_object.collision_group = COLLISION_GROUP_ENVIRONMENT;

  


  
  //FLOORS
  game_object @ramp_blue_mezToLower=_engine.create_game_cube(100,50,210,0);
  ramp_blue_mezToLower.set_position(550,0,-155);
  ramp_blue_mezToLower.set_rotation(-0.245,0,0);
  ramp_blue_mezToLower.set_color(0,0,255,mapAlpha);
  ramp_blue_mezToLower._physics_object.set_material(ice_material);
  ramp_blue_mezToLower._physics_object.set_space(_physics.space_ground);
  ramp_blue_mezToLower._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @ramp_blue_mezToUpper=_engine.create_game_cube(210,50,200,0);
  ramp_blue_mezToUpper.set_position(295,50,-600);
  ramp_blue_mezToUpper.set_rotation(0,0,0.245);
  ramp_blue_mezToUpper.set_color(0,0,255,mapAlpha);
  ramp_blue_mezToUpper._physics_object.set_material(ice_material);
  ramp_blue_mezToUpper._physics_object.set_space(_physics.space_ground);
  ramp_blue_mezToUpper._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @floor_blue_mez=_engine.create_game_cube(300,50,500,0);
  floor_blue_mez.set_position(550,25,-500);
  floor_blue_mez.set_color(0,0,255,mapAlpha);
  floor_blue_mez._physics_object.set_material(ice_material);
  floor_blue_mez._physics_object.set_space(_physics.space_ground);
  floor_blue_mez._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @floor_blue_goalroom=_engine.create_game_cube(300,50,300,0);
  floor_blue_goalroom.set_position(50,75,-600);
  floor_blue_goalroom.set_color(0,0,255,mapAlpha);
  floor_blue_goalroom._physics_object.set_material(ice_material);
  floor_blue_goalroom._physics_object.set_space(_physics.space_ground);
  floor_blue_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @ramp_red_mezToLower=_engine.create_game_cube(100,50,210,0);
  ramp_red_mezToLower.set_position(-550,0,155);
  ramp_red_mezToLower.set_rotation(0.245,0,0);
  ramp_red_mezToLower.set_color(255,0,0,mapAlpha);
  ramp_red_mezToLower._physics_object.set_material(ice_material);
  ramp_red_mezToLower._physics_object.set_space(_physics.space_ground);
  ramp_red_mezToLower._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
    game_object @ramp_red_mezToUpper=_engine.create_game_cube(210,50,200,0);
  ramp_red_mezToUpper.set_position(-295,50,600);
  ramp_red_mezToUpper.set_rotation(0,0,-0.245);
  ramp_red_mezToUpper.set_color(255,0,0,mapAlpha);
  ramp_red_mezToUpper._physics_object.set_material(ice_material);
  ramp_red_mezToUpper._physics_object.set_space(_physics.space_ground);
  ramp_red_mezToUpper._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @floor_red_mez=_engine.create_game_cube(300,50,500,0);
  floor_red_mez.set_position(-550,25,500);
  floor_red_mez.set_color(255,0,0,mapAlpha);
  floor_red_mez._physics_object.set_material(ice_material);
  floor_red_mez._physics_object.set_space(_physics.space_ground);
  floor_red_mez._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @floor_red_goalroom=_engine.create_game_cube(300,50,300,0);
  floor_red_goalroom.set_position(-50,75,600);
  floor_red_goalroom.set_color(255,0,0,mapAlpha);
  floor_red_goalroom._physics_object.set_material(ice_material);
  floor_red_goalroom._physics_object.set_space(_physics.space_ground);
  floor_red_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @bigplatform_red_goalroom=_engine.create_game_cube(200,50,250,0);
  bigplatform_red_goalroom.set_position(0,125,375);
  bigplatform_red_goalroom.set_color(255,0,0,mapAlpha);
  bigplatform_red_goalroom._physics_object.set_material(ice_material);
  bigplatform_red_goalroom._physics_object.set_space(_physics.space_ground);
  bigplatform_red_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @ramp_bigplatform_red_goalroom=_engine.create_game_cube(100,50,112,0);
  ramp_bigplatform_red_goalroom.set_position (-150,102.5,389);
  ramp_bigplatform_red_goalroom.set_rotation(-0.4636,0,0);
  ramp_bigplatform_red_goalroom.set_color(255,0,0,mapAlpha);
  ramp_bigplatform_red_goalroom._physics_object.set_material(ice_material);
  ramp_bigplatform_red_goalroom._physics_object.set_space(_physics.space_ground);
  ramp_bigplatform_red_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @ramp_smallplatform_red_goalroom=_engine.create_game_cube(112,50,50,0);
  ramp_smallplatform_red_goalroom.set_position (-39,102.5,725);
  ramp_smallplatform_red_goalroom.set_rotation(0,0,-0.4636);
  ramp_smallplatform_red_goalroom.set_color(255,0,0,mapAlpha);
  ramp_smallplatform_red_goalroom._physics_object.set_material(ice_material);
  ramp_smallplatform_red_goalroom._physics_object.set_space(_physics.space_ground);
  ramp_smallplatform_red_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @bigplatform_blue_goalroom=_engine.create_game_cube(200,50,250,0);
  bigplatform_blue_goalroom.set_position(0,125,-375);
  bigplatform_blue_goalroom.set_color(0,0,255,mapAlpha);
  bigplatform_blue_goalroom._physics_object.set_material(ice_material);
  bigplatform_blue_goalroom._physics_object.set_space(_physics.space_ground);
  bigplatform_blue_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @smallplatform_red_goalroom =_engine.create_game_cube(100,50,50,0);
  smallplatform_red_goalroom.set_position(50,125,725);
  smallplatform_red_goalroom.set_color(255,0,0,mapAlpha);
  smallplatform_red_goalroom._physics_object.set_material(ice_material);
  smallplatform_red_goalroom._physics_object.set_space(_physics.space_ground);
  smallplatform_red_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @smallplatform_blue_goalroom =_engine.create_game_cube(100,50,50,0);
  smallplatform_blue_goalroom.set_position(-50,125,-725);
  smallplatform_blue_goalroom.set_color(0,0,255,mapAlpha);
  smallplatform_blue_goalroom._physics_object.set_material(ice_material);
  smallplatform_blue_goalroom._physics_object.set_space(_physics.space_ground);
  smallplatform_blue_goalroom._physics_object.collision_group = COLLISION_GROUP_GROUND;
 
  //CENTRAL AREA FLOORS
  
  game_object @mapmesh1=_engine.create_game_cube(150,50,550,0);
  mapmesh1.set_position(125,125,-75);
  mapmesh1.set_color(0,0,255,mapAlpha);
  mapmesh1._physics_object.set_material(ice_material);
  mapmesh1._physics_object.set_space(_physics.space_ground);
  mapmesh1._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @mapmesh2=_engine.create_game_cube(150,50,550,0);
  mapmesh2.set_position(-125,125,75);
  mapmesh2.set_color(255,0,0,mapAlpha);
  mapmesh2._physics_object.set_material(ice_material);
  mapmesh2._physics_object.set_space(_physics.space_ground);
  mapmesh2._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @mapmesh3=_engine.create_game_cube(100,50,150,0);
  mapmesh3.set_position(0,125,125);
  mapmesh3.set_color(0,0,255,mapAlpha);
  mapmesh3._physics_object.set_material(ice_material);
  mapmesh3._physics_object.set_space(_physics.space_ground);
  mapmesh3._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @mapmesh4=_engine.create_game_cube(100,50,150,0);
  mapmesh4.set_position(0,125,-125);
  mapmesh4.set_color(255,0,0,mapAlpha);
  mapmesh4._physics_object.set_material(ice_material);
  mapmesh4._physics_object.set_space(_physics.space_ground);
  mapmesh4._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
    game_object @mapmesh5=_engine.create_game_cube(100,50,700,0);
  mapmesh5.set_position(250,125,-150);
  mapmesh5.set_color(0,0,255,mapAlpha);
  mapmesh5._physics_object.set_material(ice_material);
  mapmesh5._physics_object.set_space(_physics.space_ground);
  mapmesh5._physics_object.collision_group = COLLISION_GROUP_GROUND;
  
  game_object @mapmesh6=_engine.create_game_cube(100,50,700,0);
  mapmesh6.set_position(-250,125,150);
  mapmesh6.set_color(255,0,0,mapAlpha);
  mapmesh6._physics_object.set_material(ice_material);
  mapmesh6._physics_object.set_space(_physics.space_ground);
  mapmesh6._physics_object.collision_group = COLLISION_GROUP_GROUND;
 



	
	game_object @boards_mesh=_engine.create_game_mesh("ctf.obj", 1,1,1, -1);
	boards_mesh.set_position(0,0,0);
	boards_mesh.set_rotation(0,0,0);
	boards_mesh.load_texture("ctf.png");
	boards_mesh.set_material_type(EMT_SOLID);
	boards_mesh.set_fullbright();
	
	game_object @boards_mesh2=_engine.create_game_mesh("alphaObjects.obj", 1,1,1, -1);
	boards_mesh2.set_position(0,0,0);
	boards_mesh2.set_rotation(0,0,0);
	boards_mesh2.load_texture("ctf.png");
	boards_mesh2.set_material_type(EMT_TRANSPARENT_ALPHA_CHANNEL);
	boards_mesh2.set_fullbright();
	

	


	

	//boards_invisible.set_color(250,250,250,10);
	

}

void _start_game(){
  print("[_start_game]\n");
  
  _engine.game_round_time = 5 * 60;

}

void _start_round(){
  print("[_start_round]\n");

}

void _end_round(){
  print("[_end_round]\n");
}

void _start_play(){
  print("[_start_play]\n");

    active_object @new_puck = _engine.create_active_puck(70,200,0,3.2,2.35,0.02);
	
}